<%--
 This is an error page delivered by the TaskInterface servlet when an exception
 occurs rendering a task panel.  Its job is to display a more user-friendly
 error message than a Java stack trace, and optionally offer a button by which
 the user can view further details about the error, namely the Java stack trace
 for the exception.  When the user has finished viewing the error message, they
 will click on the Close button, which will close the task window.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.tasks.res.task">
<html>
<head>
   <hmc:title><fmt:message key="showErrorTitle"/></hmc:title>
   <link href="/wclres/WclBaseSkinCSS.css" rel="stylesheet" type="text/css"/>
   <link rel="stylesheet" type="text/css" href="/css/fw/hmc.css"/>
   <link rel="SHORTCUT ICON" href="/favicon.ico"/>
   <link rel="icon" href="/hmc.png" type="image/png"/>
   <script type="text/javascript" src="/js/task/taskWindow.js"></script>

   <script type="text/javascript">
      function closeButton() {
         window.close();
      }

     <c:if test="${not empty details}">
      function detailsButton() {
         // Remove the details button
         formEl = document.getElementById("buttons");
         dButton = document.getElementById("detButton");
         formEl.removeChild(dButton);

         // Change the introduction
         pEl = document.getElementById("detailsMessage");
         newInfo = document.createTextNode("<fmt:message key='showDetailsIntro'/>");
         pEl.replaceChild(newInfo, pEl.firstChild);

         // Show the details
         dArea = document.getElementById("detailsArea");
         newInfo = document.createTextNode("<c:out value='${details}' escapeXml='false'/>");
         dArea.appendChild(newInfo);

         // Exception tracebacks are long and wide.  Make the window large.
         window.moveTo(10, 10);
         window.resizeTo(screen.availWidth - 20, screen.availHeight - 20);
      }
     </c:if>

      // Stop anybody from watching this window any longer
      mw = getHMCMainWindow(window);
      if (mw != null)
         mw.markWindowCloseHandled(window.name);
      window.onunload = "";

      // Make sure the message can be read
      window.resizeTo(<fmt:message key="showErrorWindowWidth"/>,
                      <fmt:message key="showErrorWindowHeight"/>);
   </script>
</head>
<body class="errorPage">
<!-- <body bgcolor="#FFE000"> -->
<span class="wclContainer">
<h1><fmt:message key="showErrorTitle"/></h1>
<p><fmt:message key="showErrorMessage"/></p>
<c:if test="${not empty details}">
<p id="detailsMessage"><fmt:message key="showDetailsMessage"/></p>
<%-- The following <pre> will be populated when the Details button is pressed --%>
<pre id="detailsArea"></pre>
</c:if>
<form id="buttons">
   <input type="button" onclick="closeButton()" value="<fmt:message key='closeButtonLabel'/>"
          class="wclButton" onmouseout="className='wclButton'"
          onmouseover="className='wclButtonMouseOver'" />

   <c:if test="${not empty details}">
    <input id="detButton" type="button" onclick="detailsButton()"
           value="<fmt:message key='detailsButtonLabel'/>"
           class="wclButton" onmouseout="className='wclButton'"
           onmouseover="className='wclButtonMouseOver'" />
   </c:if>
</form>
</span>
</body>
</html>
</fmt:bundle>
